﻿/**
 * @fileoverview All menus here, contains mouse right click and left click 
 * @author sunnyjiang
 * @version 1.1
 */

var menuManager = {};

menuManager.showMenuInEnv = function(envId, type, menuParms) {
	if(typeof menuParms == 'undefined') { // 如果没有menuParam时
		var menuParms = {location: this.getPosition(type)};
	} else if (menuParms.hasOwnProperty("selected")) { // 解决用方向键选择菜单时的位置显示不正确的问题
		var li = $(menuParms["selected"]);
		menuLeftBottomX = li.offset().left;
		menuRightTopY  = li.offset().top;
		menuRightTopX = menuLeftBottomX + li.outerWidth() + 8; // li和外面ul的间距
		menuLeftBottomY = menuRightTopY + li.outerHeight();
		menuParms.location = {leftBottomX: menuLeftBottomX, leftBottomY: menuLeftBottomY, rightTopY: menuRightTopY, rightTopX: menuRightTopX};
	} else if(!menuParms.hasOwnProperty('location')) {
		try{
		qqbrowser.log.info("calc location");
		menuParms.location = this.getPosition(type);
		qqbrowser.log.info("over location");
		}catch(err){
		}
	} 
	tipManager.hideTooltip();
	try{
		qqbrowser.log.info("menu manager showmenu "+type);	
	}catch(err){
		console.info("menu manager showmenu: "+type);
	}
	browser.skin.menu.build(envId, type, menuParms);
};

menuManager.showMenu = function(type, menuParms) {
	this.showMenuInEnv(0, type, menuParms);
};

/**
 * charge a menu display or not
 */
menuManager.isDisplay = function(type) {
	return false;
/*	var ul = $('#menu-layer ul');
	if(ul.attr('type') == type && ul.css('display') == 'block')
		return true;
	return false;*/
};

/**
 * 获取菜单位置
 */
var POS_X_FIX = 8;
menuManager.getPosition = function(type) {
	var menuLeft = 0;
	var menuTop = 0;
	// 几种按钮菜单单独处理
	if(type == 'mainMenu' || type == 'usefulMenu' || type == 'logoMenu' || type == 'logonMenu' || type == 'recentCloseMenu') {
		var button = type == 'mainMenu' ? 
			$('#menu-button') : type == 'usefulMenu' ? 
				$('#useful-menu-button') : type == 'logoMenu' ? 
					$('#logo-menu') : type == 'recentCloseMenu' ?
							$('#undo-box') : $('#logon-menu');
		var adjustLength = 4;
					
		menuLeftBottomX = button.offset().left + adjustLength;
		menuLeftBottomY = button.offset().top + button.outerHeight() + adjustLength;	
		
		menuRightTopX = button.offset().left + button.outerWidth() - adjustLength;
		menuRightTopY = button.offset().top - adjustLength;	
	} else if(typeof type == 'number') { // 子菜单
	  // 子菜单
		var li = event.target;
		menuLeftBottomX = li.offsetLeft - POS_X_FIX;
		menuRightTopY  = li.offsetTop;
		
		// 更换定位方式后的位置计算补偿
		if (li.offsetParent) {
			menuLeftBottomX+= li.offsetParent.offsetLeft;
			menuRightTopY+= li.offsetParent.offsetTop;
		} 
		
		menuRightTopX = menuLeftBottomX + li.offsetWidth + (POS_X_FIX * 2); // li和外面ul的间距
		menuLeftBottomY = menuRightTopY + li.offsetHeight;
	} else if('favFolderMenu'==type){ //fav bar
		qqbrowser.log.info("favFolderMenu menu manager");
		try{
			var node = $(event.target);
			var maxcnt=5;
			var cnt=0;
			while(!node.is("li") && !node.is(".fav-folder") && !node.is(".fav-item") && node.attr("tagName")!="BODY" ){
				node = node.parent();
				cnt++;
				if (cnt>maxcnt){
					break;
				}
			}
			var pos = node.offset();
			menuLeftBottomX = pos.left;
			menuRightTopY = pos.top;

			menuRightTopX = menuLeftBottomX + node.outerWidth() ; 
			menuLeftBottomY = menuRightTopY + node.outerHeight();
		}catch(err){
			qqbrowser.log.info("err: "+err.message);
		}
	} else { // 右键菜单，例如地址栏、收藏栏等
		menuLeftBottomX = menuRightTopX = event.pageX;
		menuLeftBottomY = menuRightTopY = event.pageY;	
	} 
	return {leftBottomX: menuLeftBottomX, leftBottomY: menuLeftBottomY, rightTopY: menuRightTopY, rightTopX: menuRightTopX};
};

/**
 * init all menus
 */
menuManager.init = function() {
	// 禁止页面右键菜单
	$(document.body).bind("contextmenu", function() {
//		return false;
	});

	// 标签栏右键菜单，统一绑定提高效率
	$('#tabset').bind('contextmenu', function() {
		event.stopPropagation(); // 防止和标题栏右键菜单重复
		
		var element = $(event.target);
		while(!element.is('.tab') && element.attr('tagName') != 'BODY') {
			element = element.parent();
		}
		// 将id传给菜单，根据id决定对哪个tab进行操作
		var menuParams = {tabId: element.attr('id'), pageId: tabManager.getPageIdFromTab(element)};
		menuManager.showMenu("tabMenu", menuParams);
	});
	
	// 工具栏右键菜单
	$('#head-middle-wrapper').bind('contextmenu', function() {
		// 侧边栏的邮件菜单	
		var sidebar = $(event.target).closest('#sidebar-show-button')[0] || $(event.target).closest('#sidebar-hide-button')[0] ;
							// sidebar
		var aimid = $(sidebar).attr('id');
		if ("sidebar-show-button"==(aimid) || "sidebar-hide-button" ==(aimid) ){
			// 参数 main  , qzone ... 
			var para={
				contentParams:{
					type:"main"
				}
			};
			menuManager.showMenu('sidebarMenu',para);
		}else{
			menuManager.showMenu('toolbarMenu');
		}
	});
	
	// 地址栏右键菜单
	$('#address').bind('contextmenu', function() {
        // $('#address-input').focus();
        var selectionStart = document.getElementById('address-input').selectionStart;
        var selectionEnd   = document.getElementById('address-input').selectionEnd;
        var addressInput = $('#address-input').val();

        var menuParams = {
            addressInput: addressInput,
            inputText: getSelection().toString(),
            selectionStart: selectionStart,
            selectionEnd: selectionEnd
        };
		//modified by lucaszhong 地址栏右键菜单的显示统一由C++端操作 2011/3/6
		// 是否选中文字时调用不同的菜单
		//if(selectedText != '') {
			menuManager.showMenu('addressbarMenu', menuParams);
		//} else {
		//	menuManager.showMenu('addressbarBlankMenu');
		//}
		return false;
	});
	/*	
	// 收藏栏右键菜单
	$('#favbar-box').bind('contextmenu', function() {
		var element = $(event.target);
		
		if(element.is('#favholder')) { // favbar右键菜单
			menuManager.showMenu('favCtxMenu',{favType:'bar'});
		} else { // fav item右键菜单
			while(!element.is('.fav-item') && !element.is('.fav-folder') && element.attr('tagName')!='BODY') {
				element = element.parent();
			}
			if ( element.attr('tagName')!='BODY'){
				qqbrowser.log.info(element.html());
				var favId = unescape(element.attr('id'));
				var favType = element.is('.fav-item') ? 'item' : 'folder';
				var itemurl = element.attr('url'); 	
				var menuParams = {favId: favId, favType: favType, url:itemurl};
				menuManager.showMenu('favCtxMenu', menuParams);
			}else{
				qqbrowser.log.info("bar not pop menu");
			}
		}
		return false;	
	});	
	*/

    // 主菜单
    $('#menu-button').click(function() {
        if (menuManager.isDisplay('mainMenu')) {
            menuManager.hide();
        } else {
            // console.log('点击了主菜单按钮');
            browser.extension.builtin.statistics.increase(STATIS_CMD_SYSBTN_MAINMENU_CLICKED);
            menuManager.showMenu('mainMenu');
            return false;
        }
    });

    // 常用菜单
    $('#useful-menu-button').click(function() {
        if (menuManager.isDisplay('usefulMenu')) {
            menuManager.hide();
        } else {
            // console.log('点击了常用菜单按钮');
            browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_COMMON_MENU_CLICKED);
            menuManager.showMenu('usefulMenu');
            return false;
        }
    });

    // 最上面的 logo-menu/button-box/new-tab-button/tabset 阻止事件冒泡
    $('#logo-menu, #head-right-button-box, #new-tab-button').bind('contextmenu', function() {
        return false;
    });

    // 标题栏右键菜单
    $('#head-top-box').bind('contextmenu', function() {
        // var menuParams = { pageId: tabManager.getPageIdFromTab(tabManager.getCurrentTabId()) }; // lucas 注释掉的，jingle 后续帮忙看下为什么不能用这个方法
        var menuParams = { pageId: tabManager.getPageIdFromTabForBlank(tabManager.getCurrentTabId()) };
        menuManager.showMenu('titleBarMenu', menuParams);
    });

    // 增加 Tab 栏空闲位置右键菜单，修复 bug 7106267 标签栏空白处右键菜单不能激活
    $('#tab-inner').bind('contextmenu', function() {
        // var menuParams = { pageId: tabManager.getPageIdFromTab(tabManager.getCurrentTabId()) }; // lucas 注释掉的，jingle 后续帮忙看下为什么不能用这个方法
        var menuParams = { pageId: tabManager.getPageIdFromTabForBlank(tabManager.getCurrentTabId()) };
        menuManager.showMenu('titleBarMenu', menuParams);
    });
};
